/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.eui;

import ibm.nways.jdm.JmaColors;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.eui.HexInput;
import ibm.nways.jdm.eui.IPInput;
import ibm.nways.jdm.eui.ImageButton;
import ibm.nways.jdm.eui.LongNumericInput;
import ibm.nways.jdm.eui.NumericInput;
import ibm.nways.jdm.eui.OIDInput;
import ibm.nways.jdm.eui.StringInput;
import ibm.nways.jdm.eui.TableColumn;
import ibm.nways.jdm.eui.TableColumnModel;
import ibm.nways.jdm.eui.myButton;
import java.awt.AWTEventMulticaster;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Enumeration;
import mlsoft.mct.MlIconMaker;

public class EuiGridController
extends Panel
implements ActionListener {
    ImageButton top;
    ImageButton pageup;
    ImageButton up;
    ImageButton down;
    ImageButton pagedn;
    ImageButton bottom;
    myButton search;
    myButton create;
    myButton delete;
    StringInput input;
    Label label;
    ActionListener listeners;
    Panel searchPanel;
    Panel buttonPanel;
    GridBagLayout searchManager;
    GridBagLayout controllerManager;
    FlowLayout buttonManager;
    private int numIndexes;
    private StringInput[] inputFields;
    private TableColumn[] inputColumns;
    private static final int BORDER = 2;
    private static final int HEIGHT = 18;
    private static final int WIDTH = 18;
    private static final int TEXTSIZE = 8;
    private static final int INDEXSIZE = 10;
    private static Image upImage = null;
    private static Image downImage = null;
    private static Image pageUpImage = null;
    private static Image pageDownImage = null;
    private static Image topImage = null;
    private static Image bottomImage = null;
    public static final String UP = "up";
    public static final String DOWN = "down";
    public static final String PGUP = "pageup";
    public static final String PGDN = "pagedown";
    public static final String TOP = "top";
    public static final String BOT = "bottom";
    public static final String FIND = "find";

    public EuiGridController() {
        this((TableColumnModel)null);
    }

    public EuiGridController(TableColumnModel tableColumnModel) {
        MlIconMaker mlIconMaker = new MlIconMaker();
        this.controllerManager = new GridBagLayout();
        this.setLayout(this.controllerManager);
        this.numIndexes = 0;
        this.inputFields = null;
        this.inputColumns = null;
        int n = 0;
        this.buttonPanel = new Panel();
        this.buttonManager = new FlowLayout();
        this.buttonManager.setHgap(0);
        this.buttonManager.setVgap(0);
        this.buttonPanel.setLayout(this.buttonManager);
        if (topImage == null) {
            mlIconMaker.clear();
            mlIconMaker.setDimensions(14, 14);
            mlIconMaker.setColor('B', -16777216);
            mlIconMaker.setColor('.', -4144960);
            mlIconMaker.setPixels("..............");
            mlIconMaker.setPixels("..............");
            mlIconMaker.setPixels("..............");
            mlIconMaker.setPixels(".BB....B....B.");
            mlIconMaker.setPixels(".BB...BB...BB.");
            mlIconMaker.setPixels(".BB..BBB..BBB.");
            mlIconMaker.setPixels(".BB.BBBB.BBBB.");
            mlIconMaker.setPixels(".BBBBBBBBBBBB.");
            mlIconMaker.setPixels(".BB.BBBB.BBBB.");
            mlIconMaker.setPixels(".BB..BBB..BBB.");
            mlIconMaker.setPixels(".BB...BB...BB.");
            mlIconMaker.setPixels(".BB....B....B.");
            mlIconMaker.setPixels("..............");
            mlIconMaker.setPixels("..............");
            topImage = mlIconMaker.createImage(this);
        }
        this.top = new ImageButton(topImage);
        this.top.setSize(18, 18);
        this.top.addActionListener(this);
        if (pageUpImage == null) {
            mlIconMaker.clear();
            mlIconMaker.setDimensions(14, 14);
            mlIconMaker.setColor('B', -16777216);
            mlIconMaker.setColor('.', -4144960);
            mlIconMaker.setPixels("..............");
            mlIconMaker.setPixels("..............");
            mlIconMaker.setPixels("..............");
            mlIconMaker.setPixels("......B....B..");
            mlIconMaker.setPixels(".....BB...BB..");
            mlIconMaker.setPixels("....BBB..BBB..");
            mlIconMaker.setPixels("...BBBB.BBBB..");
            mlIconMaker.setPixels("..BBBBBBBBBB..");
            mlIconMaker.setPixels("...BBBB.BBBB..");
            mlIconMaker.setPixels("....BBB..BBB..");
            mlIconMaker.setPixels(".....BB...BB..");
            mlIconMaker.setPixels("......B....B..");
            mlIconMaker.setPixels("..............");
            mlIconMaker.setPixels("..............");
            pageUpImage = mlIconMaker.createImage(this);
        }
        this.pageup = new ImageButton(pageUpImage);
        this.pageup.setSize(18, 18);
        this.pageup.addActionListener(this);
        if (upImage == null) {
            mlIconMaker.clear();
            mlIconMaker.setDimensions(14, 14);
            mlIconMaker.setColor('B', -16777216);
            mlIconMaker.setColor('.', -4144960);
            mlIconMaker.setPixels("..............");
            mlIconMaker.setPixels("..............");
            mlIconMaker.setPixels("..............");
            mlIconMaker.setPixels(".........B....");
            mlIconMaker.setPixels("........BB....");
            mlIconMaker.setPixels(".......BBB....");
            mlIconMaker.setPixels("......BBBB....");
            mlIconMaker.setPixels(".....BBBBB....");
            mlIconMaker.setPixels("......BBBB....");
            mlIconMaker.setPixels(".......BBB....");
            mlIconMaker.setPixels("........BB....");
            mlIconMaker.setPixels(".........B....");
            mlIconMaker.setPixels("..............");
            mlIconMaker.setPixels("..............");
            upImage = mlIconMaker.createImage(this);
        }
        this.up = new ImageButton(upImage);
        this.up.setSize(18, 18);
        this.up.addActionListener(this);
        if (downImage == null) {
            mlIconMaker.clear();
            mlIconMaker.setDimensions(14, 14);
            mlIconMaker.setColor('B', -16777216);
            mlIconMaker.setColor('.', -4144960);
            mlIconMaker.setPixels("..............");
            mlIconMaker.setPixels("..............");
            mlIconMaker.setPixels("..............");
            mlIconMaker.setPixels("....B.........");
            mlIconMaker.setPixels("....BB........");
            mlIconMaker.setPixels("....BBB.......");
            mlIconMaker.setPixels("....BBBB......");
            mlIconMaker.setPixels("....BBBBB.....");
            mlIconMaker.setPixels("....BBBB......");
            mlIconMaker.setPixels("....BBB.......");
            mlIconMaker.setPixels("....BB........");
            mlIconMaker.setPixels("....B.........");
            mlIconMaker.setPixels("..............");
            mlIconMaker.setPixels("..............");
            downImage = mlIconMaker.createImage(this);
        }
        this.down = new ImageButton(downImage);
        this.down.setSize(18, 18);
        this.down.addActionListener(this);
        if (pageDownImage == null) {
            mlIconMaker.clear();
            mlIconMaker.setDimensions(14, 14);
            mlIconMaker.setColor('B', -16777216);
            mlIconMaker.setColor('.', -4144960);
            mlIconMaker.setPixels("..............");
            mlIconMaker.setPixels("..............");
            mlIconMaker.setPixels("..............");
            mlIconMaker.setPixels("..B....B......");
            mlIconMaker.setPixels("..BB...BB.....");
            mlIconMaker.setPixels("..BBB..BBB....");
            mlIconMaker.setPixels("..BBBB.BBBB...");
            mlIconMaker.setPixels("..BBBBBBBBBB..");
            mlIconMaker.setPixels("..BBBB.BBBB...");
            mlIconMaker.setPixels("..BBB..BBB....");
            mlIconMaker.setPixels("..BB...BB.....");
            mlIconMaker.setPixels("..B....B......");
            mlIconMaker.setPixels("..............");
            mlIconMaker.setPixels("..............");
            pageDownImage = mlIconMaker.createImage(this);
        }
        this.pagedn = new ImageButton(pageDownImage);
        this.pagedn.setSize(18, 18);
        this.pagedn.addActionListener(this);
        if (bottomImage == null) {
            mlIconMaker.clear();
            mlIconMaker.setDimensions(14, 14);
            mlIconMaker.setColor('B', -16777216);
            mlIconMaker.setColor('.', -4144960);
            mlIconMaker.setPixels("..............");
            mlIconMaker.setPixels("..............");
            mlIconMaker.setPixels("..............");
            mlIconMaker.setPixels(".B....B....BB.");
            mlIconMaker.setPixels(".BB...BB...BB.");
            mlIconMaker.setPixels(".BBB..BBB..BB.");
            mlIconMaker.setPixels(".BBBB.BBBB.BB.");
            mlIconMaker.setPixels(".BBBBBBBBBBBB.");
            mlIconMaker.setPixels(".BBBB.BBBB.BB.");
            mlIconMaker.setPixels(".BBB..BBB..BB.");
            mlIconMaker.setPixels(".BB...BB...BB.");
            mlIconMaker.setPixels(".B....B....BB.");
            mlIconMaker.setPixels("..............");
            mlIconMaker.setPixels("..............");
            bottomImage = mlIconMaker.createImage(this);
        }
        this.bottom = new ImageButton(bottomImage);
        this.bottom.setSize(18, 18);
        this.bottom.addActionListener(this);
        this.search = new myButton("SEARCH");
        this.search.addActionListener(this);
        this.buttonPanel.add(this.top);
        this.buttonPanel.add(this.pageup);
        this.buttonPanel.add(this.up);
        this.buttonPanel.add(this.down);
        this.buttonPanel.add(this.pagedn);
        this.buttonPanel.add(this.bottom);
        if (tableColumnModel != null) {
            this.buttonPanel.add(this.search);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.controllerManager.setConstraints(this.buttonPanel, gridBagConstraints);
        this.add(this.buttonPanel);
        if (tableColumnModel != null) {
            Object object;
            Object object2;
            this.searchManager = new GridBagLayout();
            this.searchPanel = new Panel();
            this.searchPanel.setLayout(this.searchManager);
            Enumeration enumeration = tableColumnModel.getColumns();
            while (enumeration.hasMoreElements()) {
                object2 = (TableColumn)enumeration.nextElement();
                if (!((TableColumn)object2).getIsIndex()) continue;
                ++this.numIndexes;
            }
            this.inputFields = new StringInput[this.numIndexes];
            this.inputColumns = new TableColumn[this.numIndexes];
            object2 = tableColumnModel.getColumns();
            while (object2.hasMoreElements()) {
                object = (TableColumn)object2.nextElement();
                if (!((TableColumn)object).getIsIndex()) continue;
                this.label = new Label(((String)((TableColumn)object).getHeaderValue()).trim(), 2);
                this.label.setFont(new Font("PLAIN", 0, 10));
                this.label.setForeground(JmaColors.textText);
                this.label.setBackground(JmaColors.background);
                GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
                gridBagConstraints2.fill = 0;
                gridBagConstraints2.weightx = 0.0;
                gridBagConstraints2.weighty = 0.0;
                gridBagConstraints2.gridx = 0;
                gridBagConstraints2.gridy = -1;
                gridBagConstraints2.anchor = 13;
                gridBagConstraints2.gridwidth = 1;
                gridBagConstraints2.gridheight = 1;
                gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
                this.searchManager.setConstraints(this.label, gridBagConstraints2);
                this.input = this.createInputField((TableColumn)object);
                GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
                gridBagConstraints3.fill = 0;
                gridBagConstraints3.weightx = 1.0;
                gridBagConstraints3.weighty = 1.0;
                gridBagConstraints3.gridx = 1;
                gridBagConstraints3.gridy = -1;
                gridBagConstraints3.anchor = 17;
                gridBagConstraints3.gridwidth = 1;
                gridBagConstraints3.gridheight = 1;
                gridBagConstraints3.insets = new Insets(0, 5, 0, 0);
                this.searchManager.setConstraints(this.input, gridBagConstraints3);
                this.searchPanel.add(this.label);
                this.searchPanel.add(this.input);
                this.inputFields[n] = this.input;
                this.inputColumns[n] = object;
                ++n;
            }
            object = new GridBagConstraints();
            ((GridBagConstraints)object).fill = 0;
            ((GridBagConstraints)object).weightx = 1.0;
            ((GridBagConstraints)object).weighty = 0.0;
            ((GridBagConstraints)object).gridx = 1;
            ((GridBagConstraints)object).gridy = -1;
            ((GridBagConstraints)object).anchor = 11;
            ((GridBagConstraints)object).gridwidth = 1;
            ((GridBagConstraints)object).gridheight = 1;
            ((GridBagConstraints)object).insets = new Insets(0, 0, 0, 0);
            this.controllerManager.setConstraints(this.searchPanel, (GridBagConstraints)object);
            this.add(this.searchPanel);
        }
    }

    public ModelInfo getInput() {
        ModelInfo modelInfo = new ModelInfo();
        int n = 0;
        while (n < this.numIndexes) {
            modelInfo.add((String)this.inputColumns[n].getIdentifier(), (Serializable)this.inputFields[n].getValue());
            ++n;
        }
        return modelInfo;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = null;
        string = actionEvent.getSource() == this.top ? TOP : (actionEvent.getSource() == this.bottom ? BOT : (actionEvent.getSource() == this.up ? UP : (actionEvent.getSource() == this.down ? DOWN : (actionEvent.getSource() == this.pageup ? PGUP : (actionEvent.getSource() == this.pagedn ? PGDN : (actionEvent.getSource() == this.search ? FIND : "unknown"))))));
        if (this.listeners != null && (string != FIND || this.input.getText().length() > 0)) {
            this.listeners.actionPerformed(new ActionEvent(this, 1001, string));
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners = AWTEventMulticaster.add(this.listeners, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listeners = AWTEventMulticaster.remove(this.listeners, actionListener);
    }

    protected StringInput createInputField(TableColumn tableColumn) {
        StringInput stringInput = null;
        switch (tableColumn.type) {
            case 5: 
            case 11: 
            case 14: {
                stringInput = new StringInput("", 30);
                stringInput.setFont(new Font("PLAIN", 0, 8));
                break;
            }
            case 1: 
            case 2: 
            case 13: 
            case 15: {
                stringInput = new LongNumericInput(0L, 30);
                stringInput.setFont(new Font("PLAIN", 0, 8));
                break;
            }
            case 4: {
                stringInput = new IPInput("", 30);
                stringInput.setFont(new Font("PLAIN", 0, 8));
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                stringInput = new HexInput("", 30);
                stringInput.setFont(new Font("PLAIN", 0, 8));
                break;
            }
            case 8: {
                stringInput = new OIDInput("", 30);
                stringInput.setFont(new Font("PLAIN", 0, 8));
                break;
            }
            case 3: 
            case 16: {
                stringInput = new NumericInput(0, 30);
                stringInput.setFont(new Font("PLAIN", 0, 8));
                break;
            }
            default: {
                stringInput = new StringInput("", 30);
                stringInput.setFont(new Font("PLAIN", 0, 8));
            }
        }
        return stringInput;
    }
}

